/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.TargetFilterExit;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class TargetFilterPanel
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMTFST";
    private static final String TRACE_MASKF = "XFRMTFSF";
    private static final String TRACE_MASKD = "XFRMTFSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "FilterTarget");

    public static ObjectId[] display(ObjectId[] objs, PanelTasklet task) {
        Trace.trace(TRACE_MASKD, "->execute()");
        LocalizableText[] names = new LocalizableText[objs.length];
        CompletionReport[] reports = new CompletionReport[objs.length];
        try {
            ObjectId[] result;
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) {
                    Trace.trace(TRACE_MASKD, " Object " + i + " is null");
                    names[i] = new LocalizableText("" + i);
                    reports[i] = new CompletionReport();
                    continue;
                }
                ManagedObject mObj = (ManagedObject)mom.get(objs[i]);
                if (mObj == null) {
                    Trace.trace(TRACE_MASKD, " Object " + i + " not in MOM");
                    names[i] = new LocalizableText("" + i);
                    reports[i] = new CompletionReport();
                    continue;
                }
                if (mObj.getUIInfo() == null || mObj.getUIInfo().getUnlocalizedName() == null) {
                    Trace.trace(TRACE_MASKD, " Object " + i + " bad UI Info");
                    names[i] = new LocalizableText("" + i);
                } else {
                    names[i] = mObj.getUIInfo().getUnlocalizedName();
                }
                if (mObj.getLastTaskReport() == null) {
                    reports[i] = new CompletionReport();
                    Trace.trace(TRACE_MASKD, " Object " + i + " no CompletionReport");
                    continue;
                }
                reports[i] = mObj.getLastTaskReport();
            }
            int[] selection = (int[])task.invokeExitOnClient(new TargetFilterExit(names, reports));
            if (selection != null) {
                Trace.trace(TRACE_MASKD, "TargetFiltering got selection from table: #" + selection.length);
            } else {
                Trace.trace(TRACE_MASKD, "TargetFiltering got empty selection ");
            }
            int goodCount = 0;
            if (selection != null) {
                for (int i = 0; i < selection.length; ++i) {
                    if (reports[selection[i]].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                        ++goodCount;
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "Completion Code for " + i + " is NOT  SUCCESS, object will be removed");
                }
                if (goodCount > 0) {
                    result = new ObjectId[goodCount];
                    int j = 0;
                    for (int i = 0; i < selection.length; ++i) {
                        if (!reports[selection[i]].getCompletionCode().equals(CompletionReportCode.SUCCESS)) continue;
                        result[j] = objs[selection[i]];
                        ++j;
                    }
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
            Trace.trace(TRACE_MASKD, "<-exit()");
            return result;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "(TargetFilterServer) Exception showing message box " + e);
            new FrameworkLog(classLogInfo, 64, e).log();
            return null;
        }
    }
}

